/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.item.loader;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.class_1747;
import net.minecraft.class_1748;
import net.minecraft.class_1765;
import net.minecraft.class_1792;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2320;
import net.minecraft.class_2323;
import net.minecraft.class_2960;
import net.minecraft.class_3734;
import net.minecraft.class_3736;
import net.minecraft.class_7923;
import snownee.kiwi.customization.item.loader.ItemDefinitionProperties;
import snownee.kiwi.customization.item.loader.KItemTemplate;
import snownee.kiwi.customization.item.loader.KItemTemplates;
import snownee.kiwi.util.resource.OneTimeLoader;

public final class BlockItemTemplate
extends KItemTemplate {
    private final Optional<class_2960> block;
    private final String clazz;
    private BiFunction<class_2248, class_1792.class_1793, class_1792> constructor;

    public BlockItemTemplate(Optional<ItemDefinitionProperties> properties, Optional<class_2960> block, String clazz) {
        super(properties);
        this.block = block;
        this.clazz = clazz;
    }

    public static Codec<BlockItemTemplate> directCodec() {
        return RecordCodecBuilder.create(instance -> instance.group((App)ItemDefinitionProperties.mapCodecField().forGetter(KItemTemplate::properties), (App)class_2960.field_25139.optionalFieldOf("block").forGetter(BlockItemTemplate::block), (App)Codec.STRING.optionalFieldOf("class", (Object)"").forGetter(BlockItemTemplate::clazz)).apply((Applicative)instance, BlockItemTemplate::new));
    }

    @Override
    public KItemTemplate.Type<?> type() {
        return KItemTemplates.BLOCK.getOrCreate();
    }

    @Override
    public void resolve(class_2960 key, OneTimeLoader.Context context) {
        if (this.clazz.isEmpty()) {
            this.constructor = (block, properties) -> {
                if (block instanceof class_2323 || block instanceof class_2320) {
                    return new class_1765(block, properties);
                }
                if (block instanceof class_2244) {
                    return new class_1748(block, properties);
                }
                if (block instanceof class_3736) {
                    return new class_3734(block, properties);
                }
                return new class_1747(block, properties);
            };
            return;
        }
        try {
            Class<?> clazz = Class.forName(this.clazz);
            this.constructor = (block, properties) -> {
                try {
                    return (class_1792)clazz.getConstructor(class_2248.class, class_1792.class_1793.class).newInstance(block, properties);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            };
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public class_1792 createItem(class_2960 id, class_1792.class_1793 properties, JsonObject json) {
        class_2248 block = (class_2248)class_7923.field_41175.method_10223(this.block.orElse(id));
        Preconditions.checkState((block != class_2246.field_10124 ? 1 : 0) != 0, (String)"Block %s not found", this.block);
        return this.constructor.apply(block, properties);
    }

    public Optional<class_2960> block() {
        return this.block;
    }

    public String clazz() {
        return this.clazz;
    }

    public String toString() {
        return "BlockItemTemplate[properties=" + this.properties + ", block=" + this.block + "]";
    }
}

